;**************************************************************************
;*          Egg Timer              *
; 
; The 7 segments are at RB0 to RB6. RB7 is the output for the buzzer.
; The reset/minute button is used for reset during run or alarm and
; to set minutes at other times.
; TMR0 is set to 1 second as time base for the clock.
;
; This code is free to use, for more info   http://www.moty22.co.uk      
;**************************************************************************
#include <p16F628.inc>

;==========================================================================
;
;       Configuration Bits
;
;==========================================================================

_BODEN_ON                    EQU     H'3FFF'
_BODEN_OFF                   EQU     H'3FBF'
_CP_ALL                      EQU     H'03FF'
_CP_75                       EQU     H'17FF'
_CP_50                       EQU     H'2BFF'
_CP_OFF                      EQU     H'3FFF'
_DATA_CP_ON                  EQU     H'3EFF'
_DATA_CP_OFF                 EQU     H'3FFF'
_PWRTE_OFF                   EQU     H'3FFF'
_PWRTE_ON                    EQU     H'3FF7'
_WDT_ON                      EQU     H'3FFF'
_WDT_OFF                     EQU     H'3FFB'
_LVP_ON                      EQU     H'3FFF'
_LVP_OFF                     EQU     H'3F7F'
_MCLRE_ON                    EQU     H'3FFF'
_MCLRE_OFF                   EQU     H'3FDF'
_ER_OSC_CLKOUT               EQU     H'3FFF'
_ER_OSC_NOCLKOUT             EQU     H'3FFE'
_INTRC_OSC_CLKOUT            EQU     H'3FFD'
_INTRC_OSC_NOCLKOUT          EQU     H'3FFC'
_EXTCLK_OSC                  EQU     H'3FEF'
_LP_OSC                      EQU     H'3FEC'
_XT_OSC                      EQU     H'3FED'
_HS_OSC                      EQU     H'3FEE'

	__CONFIG      _BODEN_ON & _CP_OFF & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _LP_OSC  ; 

;==========================================================================
;       Variable Definition
;==========================================================================
#define	seconds .60
#define	start PORTA,4		;start button
#define	min_rst PORTA,2		;minute/reset button
#define	min_x10 PORTA,3		;10 minutes button

digit1		EQU	H'20'		
digit2      EQU H'21'
TIMER1		EQU	H'22'		
TIMER2      EQU H'23'
minute      EQU H'24'
rings       EQU H'25'
alrm        EQU H'26'

		ORG	0		;Reset vector address
		GOTO	init		

DELAY1  MOVLW   D'26'     ;10msec delay     
        MOVWF   TIMER1
LOOP1   DECFSZ  TIMER1,F
        GOTO    LOOP1
		return
		
table   addwf   PCL,f         ;7 segment table 
        retlw   B'111111'     ;0   	     	
        retlw   B'110'        ;1
        retlw   B'1011011'
        retlw   B'1001111'
        retlw   B'1100110'
        retlw   B'1101101'
        retlw   B'1111100'
        retlw   B'111'
        retlw   B'1111111'
        retlw   B'1100111'    ;9
        retlw   B'1110111'		;A
        retlw   B'111000'    ;L		
		
dply1  	movfw   digit1    ;7 segments converter
    	call    table
    	movwf   PORTB     ;port outputs the selected segments 
    	movlw   .1
    	movwf   PORTA     ;digit selected 
    	call    delay1    ;sets the mux to 100Hz
     	movfw   digit2   ;7 segments converter
    	call    table
    	movwf   PORTB
    	movlw   .2
    	movwf   PORTA
    	call    delay1
    	return
    	
beep    movlw   D'64'     ;.25 sec beep
	    movwf   timer2     	
loop3   bsf     PORTB,7   ;output 1KHz
        nop
        nop
        nop
        bcf     PORTB,7
    	decfsz  timer2,F
    	goto    loop3
    	return    	 		
		
init	MOVLW	B'00000111'	;Disable Comparator module's
		MOVWF	CMCON
		BSF	    STATUS,RP0	;Switch to bank 1
		MOVLW	B'100'	    ;TMR0 prescale-1:32
		MOVWF	OPTION_REG	
		clrf	TRISB		 ;RB all outputs
		MOVLW	B'11111100'	 ;RA 0,1 outputs
		MOVWF	TRISA
		BCF	    STATUS,RP0	;Switch to Bank 0

init2   movlw   seconds      ;seconds counter
    	movwf   minute
        clrf    digit1
        clrf    digit2
        
main    call    dply1          ;open switches loop
    	btfss   start
    	goto    prerun
    	btfss   min_rst       ;+MINUTE switch
    	goto    incmin
    	btfss   min_x10        ;+MINUTE X 10 switch
    	goto    incm10
    	goto    main
incmin 	incf    digit2,F          ;increment min
    	movlw   .10             ;is min=10    
    	subwf   digit2,W
    	btfsc   STATUS,Z
    	clrf    digit2
        clrf    TMR0
        bcf     INTCON,T0IF    	
dly1   	call    dply1          ;1 sec loop
        btfsc   min_rst       ;is +MINUTE switch pressed
    	goto    main
    	btfss   INTCON,T0IF   ;TMR0=1 sec timer
    	goto    dly1
    	goto    main
incm10 	incf    digit1,F        ;increment min10
    	movlw   .10             ;is min10=10
    	subwf   digit1,W
    	btfsc   STATUS,Z       
    	clrf    digit1     	
        clrf    TMR0
        bcf     INTCON,T0IF    	
dly2   	call    dply1          ;1 sec loop
    	btfsc   min_x10        ;is +MINUTE X 10 pressed
    	goto    main
    	btfss   INTCON,T0IF   ;TMR0=1 sec timer
    	goto    dly2
    	goto    main      	
     	
prerun  
		movf    digit2,f            ;test if display is zero   
    	btfss   STATUS,Z
    	goto    $+4         ;if no
    	movf    digit1,f            ;test if display is zero   
    	btfsc   STATUS,Z
    	goto    main          ;if yes
		call    beep    	
run    	call    dply1
    	btfss   min_rst 
    	goto    stop
    	
    	movf    digit2,f            ;test if display is zero   
    	btfss   STATUS,Z
    	goto    clock         ;no
    	movf    digit1,f            ;test if display is zero   
    	btfsc   STATUS,Z
    	goto    bell          ;if yes then ring
    	              	    	     	    	
clock   btfss   INTCON,T0IF   ;60 seconds count
    	goto    run
    	bcf     INTCON,T0IF
    	decf    minute,F
    	btfss   STATUS,Z       
    	goto    run
    	movlw   seconds
    	movwf   minute
    	   	
     	movlw   .1             ;dec digit2    
    	subwf   digit2,F
    	btfsc   STATUS,C
    	goto    run
    	movlw   .9
    	movwf   digit2        ;set digit1 to 9
    	decf    digit1,F
        goto    run

bell    movlw   .20           ;number of beeps  
    	movwf   rings
    	movlw	.10
    	movwf	digit1
    	movlw	.11
    	movwf	digit2
ring   	btfss   min_rst
    	goto    stop
    	movlw	.40
    	movwf	alrm
    	call    beep
AL    	call    dply1
    	decfsz  alrm,f
    	goto	AL
    	clrf	PORTB
       	decfsz  rings,F      ;rings counter
    	goto    ring
     	goto    init2       ;end of alarm
     	
stop    movlw   seconds
    	movwf   minute
        clrf    digit1
        clrf    digit2
loop2 	call    dply1      ;mux digits
        btfss   min_rst       ;reset switch
        goto    loop2
        goto    main     	   
    	    	
		END
